/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DauthiVoidwalkerPlayEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("exiled card an opponent owns with a void counter on it");

    DauthiVoidwalkerPlayEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose an exiled card an opponent owns with a void counter on it. You may play it this turn without paying its mana cost";
    }

    private DauthiVoidwalkerPlayEffect(DauthiVoidwalkerPlayEffect effect) {
        super((OneShotEffect)effect);
    }

    public DauthiVoidwalkerPlayEffect copy() {
        return new DauthiVoidwalkerPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(0, 1, filter);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.EndOfTurn, true, false).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        game.informPlayers(game.getObject(source).getLogName() + ": " + player.getLogName() + " has chosen " + card.getLogName());
        return true;
    }

    static {
        filter.add((Predicate)CounterType.VOID.getPredicate());
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getOwnerPredicate());
    }
}

