/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetOpponent;

class DawnbreakReclaimerEffect
extends OneShotEffect {
    DawnbreakReclaimerEffect() {
        super(Outcome.Detriment);
        this.staticText = "choose a creature card in an opponent's graveyard, then that player chooses a creature card in your graveyard. You may return those cards to the battlefield under their owners' control";
    }

    private DawnbreakReclaimerEffect(DawnbreakReclaimerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DawnbreakReclaimerEffect copy() {
        return new DawnbreakReclaimerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            FilterCreatureCard filter = new FilterCreatureCard("a creature card in an opponent's graveyard");
            filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getOwnerPredicate());
            TargetCard chosenCreatureOpponentGraveyard = new TargetCard(Zone.GRAVEYARD, (FilterCard)filter);
            Player opponent = null;
            Card cardOpponentGraveyard = null;
            chosenCreatureOpponentGraveyard.withNotTarget(true);
            if (chosenCreatureOpponentGraveyard.canChoose(source.getControllerId(), source, game)) {
                controller.choose(Outcome.Detriment, (Target)chosenCreatureOpponentGraveyard, source, game);
                cardOpponentGraveyard = game.getCard(chosenCreatureOpponentGraveyard.getFirstTarget());
                if (cardOpponentGraveyard != null) {
                    opponent = game.getPlayer(cardOpponentGraveyard.getOwnerId());
                    game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " has chosen " + cardOpponentGraveyard.getIdName() + " of " + opponent.getLogName());
                }
            }
            if (opponent == null) {
                TargetOpponent targetOpponent = new TargetOpponent(true);
                controller.choose(this.outcome, (Target)targetOpponent, source, game);
                opponent = game.getPlayer(targetOpponent.getFirstTarget());
                if (opponent != null) {
                    game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " has chosen " + opponent.getLogName() + " to select a creature card from their graveyard");
                }
            }
            if (opponent != null) {
                FilterCreatureCard filterCreatureCard = new FilterCreatureCard("a creature card in " + controller.getName() + "'s the graveyard");
                filterCreatureCard.add((Predicate)new OwnerIdPredicate(controller.getId()));
                TargetCardInGraveyard targetControllerGaveyard = new TargetCardInGraveyard((FilterCard)filterCreatureCard);
                targetControllerGaveyard.withNotTarget(true);
                Card controllerCreatureCard = null;
                if (targetControllerGaveyard.canChoose(opponent.getId(), source, game) && opponent.choose(this.outcome, (Target)targetControllerGaveyard, source, game) && (controllerCreatureCard = game.getCard(targetControllerGaveyard.getFirstTarget())) != null) {
                    game.informPlayers(sourceObject.getLogName() + ": " + opponent.getLogName() + " has chosen " + controllerCreatureCard.getIdName() + " of " + controller.getLogName());
                }
                HashSet<Card> cards = new HashSet<Card>();
                if (cardOpponentGraveyard != null) {
                    cards.add(cardOpponentGraveyard);
                }
                if (controllerCreatureCard != null) {
                    cards.add(controllerCreatureCard);
                }
                if (!cards.isEmpty() && controller.chooseUse(this.outcome, "Return those cards to the battlefield under their owners' control?", "Opponent's creature card: " + (cardOpponentGraveyard == null ? "none" : cardOpponentGraveyard.getLogName()) + ", your creature card: " + (controllerCreatureCard == null ? "none" : controllerCreatureCard.getLogName()), null, null, source, game)) {
                    controller.moveCards(cards, Zone.BATTLEFIELD, source, game, false, false, true, null);
                }
            }
            return true;
        }
        return false;
    }
}

