/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class DeadIronSledgeTriggeredAbility
extends TriggeredAbilityImpl {
    public DeadIronSledgeTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever equipped creature blocks or becomes blocked by a creature, ");
    }

    private DeadIronSledgeTriggeredAbility(DeadIronSledgeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent equipped;
        Permanent equipment = game.getPermanent(this.sourceId);
        if (equipment != null && equipment.getAttachedTo() != null && ((equipped = game.getPermanent(equipment.getAttachedTo())).getId().equals(event.getTargetId()) || equipped.getId().equals(event.getSourceId()))) {
            Permanent blocked;
            ArrayList<Permanent> targets = new ArrayList<Permanent>();
            Permanent blocker = game.getPermanent(event.getSourceId());
            if (blocker != null) {
                targets.add(blocker);
            }
            if ((blocked = game.getPermanent(event.getTargetId())) != null) {
                targets.add(blocked);
            }
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTargets(targets, game));
            return true;
        }
        return false;
    }

    public DeadIronSledgeTriggeredAbility copy() {
        return new DeadIronSledgeTriggeredAbility(this);
    }
}

