/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.cards.d.DeafeningSilenceWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class DeafeningSilenceEffect
extends ContinuousRuleModifyingEffectImpl {
    DeafeningSilenceEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Each player can't cast more than one noncreature spell each turn";
    }

    private DeafeningSilenceEffect(DeafeningSilenceEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        return "Each player can't cast more than one noncreature spell each turn";
    }

    public DeafeningSilenceEffect copy() {
        return new DeafeningSilenceEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getSourceId());
        if (card == null || card.isCreature(game)) {
            return false;
        }
        DeafeningSilenceWatcher watcher = (DeafeningSilenceWatcher)game.getState().getWatcher(DeafeningSilenceWatcher.class);
        return watcher != null && watcher.spellsCastByPlayerThisTurnNonCreature(event.getPlayerId()) > 0;
    }
}

