/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.d.DeathKissEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DeathKissAdjusterTriggeredAbility
extends TriggeredAbilityImpl {
    DeathKissAdjusterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DeathKissEffect());
    }

    private DeathKissAdjusterTriggeredAbility(DeathKissAdjusterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DeathKissAdjusterTriggeredAbility copy() {
        return new DeathKissAdjusterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Set opponents = game.getOpponents(this.getControllerId());
        if (opponents.contains(game.getControllerId(event.getSourceId())) && opponents.contains(event.getTargetId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature an opponent controls attacks one of your opponents, double its power until end of turn.";
    }
}

