/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class DeathMatchEffect
extends OneShotEffect {
    DeathMatchEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "that creature's controller may have target creature of their choice get -3/-3 until end of turn.";
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(((Target)source.getTargets().get(0)).getTargetController());
        if (player != null) {
            if (player.chooseUse(this.outcome, "Give targeted creature -3/-3 ?", source, game)) {
                game.addEffect((ContinuousEffect)new BoostTargetEffect(-3, -3, Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }

    private DeathMatchEffect(DeathMatchEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeathMatchEffect copy() {
        return new DeathMatchEffect(this);
    }
}

