/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieToken;

class DeathTyrantTriggeredAbility
extends TriggeredAbilityImpl {
    DeathTyrantTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new ZombieToken()));
        this.setTriggerPhrase("Whenever an attacking creature you control or a blocking creature an opponent controls dies, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private DeathTyrantTriggeredAbility(DeathTyrantTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DeathTyrantTriggeredAbility copy() {
        return new DeathTyrantTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && (permanent = game.getPermanentOrLKIBattlefield(zEvent.getTargetId())) != null && permanent.isCreature(game)) {
            if (permanent.isControlledBy(this.controllerId) && permanent.isAttacking()) {
                return true;
            }
            return game.getOpponents(this.controllerId).contains(permanent.getControllerId()) && permanent.getBlocking() > 0;
        }
        return false;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

