/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DiesAttachedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class DeathWatch
extends CardImpl {
    public DeathWatch(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{B}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.Detriment));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new DiesAttachedTriggeredAbility((Effect)new DeathWatchEffect(), "enchanted creature"));
    }

    private DeathWatch(DeathWatch card) {
        super((CardImpl)card);
    }

    public DeathWatch copy() {
        return new DeathWatch(this);
    }

    static class DeathWatchEffect
    extends OneShotEffect {
        public DeathWatchEffect() {
            super(Outcome.LoseLife);
            this.staticText = "that creature's controller loses life equal to its power and you gain life equal to its toughness.";
        }

        private DeathWatchEffect(DeathWatchEffect copy) {
            super((OneShotEffect)copy);
        }

        public DeathWatchEffect copy() {
            return new DeathWatchEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player controller;
            Player opponent;
            Permanent creature = (Permanent)this.getValue("attachedTo");
            if (creature != null && (opponent = game.getPlayer(creature.getOwnerId())) != null && (controller = game.getPlayer(source.getControllerId())) != null) {
                controller.gainLife(creature.getToughness().getValue(), game, source);
                opponent.loseLife(creature.getPower().getValue(), game, source, false);
                return true;
            }
            return false;
        }
    }
}

