/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DeathgorgeScavengerEffect
extends OneShotEffect {
    DeathgorgeScavengerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target card from a graveyard. If a creature card is exiled this way, you gain 2 life. If a noncreature card is exiled this way, {this} gets +1/+1 until end of turn";
    }

    private DeathgorgeScavengerEffect(DeathgorgeScavengerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeathgorgeScavengerEffect copy() {
        return new DeathgorgeScavengerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (card != null) {
                controller.moveCards(card, Zone.EXILED, source, game);
                if (card.isCreature(game)) {
                    controller.gainLife(2, game, source);
                } else {
                    game.addEffect((ContinuousEffect)new BoostSourceEffect(1, 1, Duration.EndOfTurn), source);
                }
            }
            return true;
        }
        return false;
    }
}

