/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DeathmistRaptorEffect
extends OneShotEffect {
    DeathmistRaptorEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may return this card from your graveyard to the battlefield face up or face down";
    }

    private DeathmistRaptorEffect(DeathmistRaptorEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeathmistRaptorEffect copy() {
        return new DeathmistRaptorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (controller != null && card != null) {
            return controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, controller.chooseUse(Outcome.Detriment, "Return " + card.getLogName() + " face down to battlefield (otherwise face up)?", source, game), false, null);
        }
        return false;
    }
}

