/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class DeathrenderEffect
extends OneShotEffect {
    DeathrenderEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may put a creature card from your hand onto the battlefield and attach {this} to it";
    }

    private DeathrenderEffect(DeathrenderEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeathrenderEffect copy() {
        return new DeathrenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Card creatureInHand;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        if (controller.choose(Outcome.PutCardInPlay, (Target)target, source, game) && (creatureInHand = game.getCard(target.getFirstTarget())) != null && controller.moveCards(creatureInHand, Zone.BATTLEFIELD, source, game) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)creatureInHand, (Game)game)) != null) {
            permanent.addAttachment(sourcePermanent.getId(), source, game);
        }
        return true;
    }
}

