/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class DeathsOasisEffect
extends OneShotEffect {
    private final FilterCard filter;

    DeathsOasisEffect(int cmc) {
        super(Outcome.Benefit);
        this.filter = new FilterCreatureCard("creature card in your graveyard with mana value " + (cmc - 1) + " or less");
        this.filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, cmc));
    }

    private DeathsOasisEffect(DeathsOasisEffect effect) {
        super((OneShotEffect)effect);
        this.filter = effect.filter.copy();
    }

    public DeathsOasisEffect copy() {
        return new DeathsOasisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count(this.filter, game) == 0) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(this.filter);
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game)) {
            return false;
        }
        return player.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
    }
}

