/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.common.counter.RemoveCounterTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DecimatorBeetleEffect
extends OneShotEffect {
    DecimatorBeetleEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "remove a -1/-1 counter from target creature you control and put a -1/-1 counter on up to one target creature defending player controls";
    }

    private DecimatorBeetleEffect(DecimatorBeetleEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        RemoveCounterTargetEffect effect;
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null && targetCreature.getCounters(game).containsKey(CounterType.M1M1)) {
            effect = new RemoveCounterTargetEffect(CounterType.M1M1.createInstance(1));
            effect.setTargetPointer(this.getTargetPointer().copy());
            effect.apply(game, source);
        }
        if ((targetCreature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            effect = new AddCountersTargetEffect(CounterType.M1M1.createInstance(1));
            effect.setTargetPointer((TargetPointer)new FixedTarget(((Target)source.getTargets().get(1)).getFirstTarget(), game));
            effect.apply(game, source);
        }
        return true;
    }

    public DecimatorBeetleEffect copy() {
        return new DecimatorBeetleEffect(this);
    }
}

