/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateTargetEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class DeclarationInStoneEffect
extends OneShotEffect {
    DeclarationInStoneEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target creature and all other creatures its controller controls with the same name as that creature. That player investigates for each nontoken creature exiled this way.";
    }

    private DeclarationInStoneEffect(DeclarationInStoneEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || sourceObject == null || targetPermanent == null) {
            return false;
        }
        HashSet<Permanent> cardsToExile = new HashSet<Permanent>();
        int nonTokenCount = 0;
        if (CardUtil.haveEmptyName((MageObject)targetPermanent)) {
            cardsToExile.add(targetPermanent);
            if (!(targetPermanent instanceof PermanentToken)) {
                ++nonTokenCount;
            }
        } else {
            if (cardsToExile.add(targetPermanent) && !(targetPermanent instanceof PermanentToken)) {
                ++nonTokenCount;
            }
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, targetPermanent.getControllerId(), game)) {
                if (permanent.getId().equals(targetPermanent.getId()) || !CardUtil.haveSameNames((MageObject)permanent, (MageObject)targetPermanent)) continue;
                cardsToExile.add(permanent);
                if (permanent instanceof PermanentToken) continue;
                ++nonTokenCount;
            }
        }
        controller.moveCards(cardsToExile, Zone.EXILED, source, game);
        game.processAction();
        if (nonTokenCount > 0) {
            new InvestigateTargetEffect(nonTokenCount).setTargetPointer((TargetPointer)new FixedTarget(targetPermanent.getControllerId())).apply(game, source);
        }
        return true;
    }

    public DeclarationInStoneEffect copy() {
        return new DeclarationInStoneEffect(this);
    }
}

