/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class DecoyGambitEffect
extends OneShotEffect {
    DecoyGambitEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each opponent, choose up to one target creature that player controls, then return that creature to its owner's hand unless its controller has you draw a card.";
    }

    private DecoyGambitEffect(DecoyGambitEffect effect) {
        super((OneShotEffect)effect);
    }

    public DecoyGambitEffect copy() {
        return new DecoyGambitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        CardsImpl permanentToHand = new CardsImpl();
        int numberOfCardsToDraw = 0;
        if (controller == null) {
            return false;
        }
        List permanents = source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        for (Permanent permanent : permanents) {
            Player player = game.getPlayer(permanent.getControllerId());
            if (player == null) continue;
            if (player.chooseUse(this.outcome, "Have " + controller.getName() + " draw a card? If you don't, " + permanent.getLogName() + " will be returned to its owner's hand.", source, game)) {
                game.informPlayers(player.getLogName() + " chose to have " + controller.getName() + " draw a card.");
                ++numberOfCardsToDraw;
                continue;
            }
            game.informPlayers(player.getLogName() + " chose to have their creature " + permanent.getLogName() + " returned to their hand.");
            permanentToHand.add((Card)permanent);
        }
        controller.drawCards(numberOfCardsToDraw, source, game);
        controller.moveCards((Cards)permanentToHand, Zone.HAND, source, game);
        return true;
    }
}

