/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class DefiantBloodlordTriggeredAbility
extends TriggeredAbilityImpl {
    public DefiantBloodlordTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private DefiantBloodlordTriggeredAbility(DefiantBloodlordTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DefiantBloodlordTriggeredAbility copy() {
        return new DefiantBloodlordTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAINED_LIFE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.controllerId)) {
            this.getEffects().clear();
            this.addEffect((Effect)new LoseLifeTargetEffect(event.getAmount()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever you gain life, target opponent loses that much life.";
    }
}

