/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DefiantVanguardEffect
extends OneShotEffect {
    DefiantVanguardEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy it and all creatures it blocked this turn";
    }

    private DefiantVanguardEffect(DefiantVanguardEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        boolean result = false;
        Permanent blockedCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent defiantVanguard = game.getPermanent(source.getSourceId());
        if (blockedCreature != null && game.getState().getValue("DefiantVanguardEffect_" + blockedCreature.getId()).equals(blockedCreature.getZoneChangeCounter(game))) {
            blockedCreature.destroy(source, game, false);
            result = true;
        }
        if (defiantVanguard != null && game.getState().getValue("DefiantVanguardEffect_" + defiantVanguard.getId()).equals(defiantVanguard.getZoneChangeCounter(game))) {
            defiantVanguard.destroy(source, game, false);
            result = true;
        }
        return result;
    }

    public DefiantVanguardEffect copy() {
        return new DefiantVanguardEffect(this);
    }
}

