/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.common.search.SearchTargetGraveyardHandLibraryForCardNameAndExileEffect;
import mage.cards.Card;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DeicideExileEffect
extends SearchTargetGraveyardHandLibraryForCardNameAndExileEffect {
    DeicideExileEffect() {
        super(true, "its controller's", "any number of cards with the same name as that card");
        this.staticText = "Exile target enchantment. If the exiled card is a God card, " + this.staticText;
    }

    private DeicideExileEffect(DeicideExileEffect effect) {
        super((SearchTargetGraveyardHandLibraryForCardNameAndExileEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card sourceCard = game.getCard(source.getSourceId());
        if (controller == null || sourceCard == null) {
            return false;
        }
        Permanent targetEnchantment = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetEnchantment == null) {
            return false;
        }
        controller.moveCards((Card)targetEnchantment, Zone.EXILED, source, game);
        game.processAction();
        Card cardInExile = game.getExile().getCard(targetEnchantment.getId(), game);
        if (cardInExile != null && cardInExile.hasSubtype(SubType.GOD, game)) {
            Player enchantmentController = game.getPlayer(targetEnchantment.getControllerId());
            return enchantmentController != null && super.applySearchAndExile(game, source, cardInExile.getName(), enchantmentController.getId());
        }
        return false;
    }

    public DeicideExileEffect copy() {
        return new DeicideExileEffect(this);
    }
}

