/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInPlayersNextUntapStepAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DelayTacticEffect
extends OneShotEffect {
    DelayTacticEffect() {
        super(Outcome.Benefit);
        this.staticText = "Creatures target opponent controls don't untap during their next untap step";
    }

    private DelayTacticEffect(DelayTacticEffect effect) {
        super((OneShotEffect)effect);
    }

    public DelayTacticEffect copy() {
        return new DelayTacticEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
            DontUntapInPlayersNextUntapStepAllEffect effect = new DontUntapInPlayersNextUntapStepAllEffect((FilterPermanent)filter);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetPlayer.getId()));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

