/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;

class DelayingShieldReplacementEffect
extends ReplacementEffectImpl {
    DelayingShieldReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.PreventDamage);
        this.staticText = "If damage would be dealt to you, put that many delay counters on {this} instead";
    }

    private DelayingShieldReplacementEffect(DelayingShieldReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        new AddCountersSourceEffect(CounterType.DELAY.createInstance(damageEvent.getAmount()), true).apply(game, source);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getControllerId());
    }

    public DelayingShieldReplacementEffect copy() {
        return new DelayingShieldReplacementEffect(this);
    }
}

