/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DelayingShieldUpkeepEffect
extends OneShotEffect {
    DelayingShieldUpkeepEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove all delay counters from {this}. For each delay counter removed this way, you lose 1 life unless you pay {1}{W}";
    }

    private DelayingShieldUpkeepEffect(DelayingShieldUpkeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public DelayingShieldUpkeepEffect copy() {
        return new DelayingShieldUpkeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            int countersRemoved;
            for (int i = countersRemoved = permanent.removeAllCounters(CounterType.DELAY.getName(), source, game); i > 0; --i) {
                ManaCostsImpl cost;
                if (controller.chooseUse(Outcome.Benefit, "Pay {1}{W}? (" + i + " counters left to pay)", source, game) && (cost = new ManaCostsImpl("{1}{W}")).pay(source, game, source, source.getControllerId(), false, null)) continue;
                new LoseLifeSourceControllerEffect(1).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

