/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.d.DelightedHalflingWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class DelightedHalflingCantCounterEffect
extends ContinuousRuleModifyingEffectImpl {
    DelightedHalflingCantCounterEffect() {
        super(Duration.EndOfGame, Outcome.Benefit);
    }

    private DelightedHalflingCantCounterEffect(DelightedHalflingCantCounterEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public DelightedHalflingCantCounterEffect copy() {
        return new DelightedHalflingCantCounterEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null) {
            return "This spell can't be countered because a colored mana from " + sourceObject.getName() + " was spent to cast it.";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        DelightedHalflingWatcher watcher = (DelightedHalflingWatcher)game.getState().getWatcher(DelightedHalflingWatcher.class, source.getSourceId());
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && watcher != null && watcher.spellCantBeCountered(new MageObjectReference((MageObject)spell, game));
    }
}

