/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.d.DemonOfFatesDesignAlternativeCostSourceAbility;
import mage.cards.d.DemonOfFatesDesignWatcher;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class DemonOfFatesDesignCastEffect
extends ContinuousEffectImpl {
    private final DemonOfFatesDesignAlternativeCostSourceAbility alternativeCastingCostAbility = new DemonOfFatesDesignAlternativeCostSourceAbility();

    DemonOfFatesDesignCastEffect() {
        super(Duration.WhileOnBattlefield, Layer.RulesEffects, SubLayer.NA, Outcome.Neutral);
        this.staticText = "once during each of your turns, you may cast an enchantment spell by paying life equal to its mana value rather than paying its mana cost.";
    }

    private DemonOfFatesDesignCastEffect(DemonOfFatesDesignCastEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public DemonOfFatesDesignCastEffect copy() {
        return new DemonOfFatesDesignCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        DemonOfFatesDesignWatcher watcher = (DemonOfFatesDesignWatcher)game.getState().getWatcher(DemonOfFatesDesignWatcher.class);
        if (controller == null || watcher == null) {
            return false;
        }
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
        if (!watcher.canAbilityBeUsed(game, source, this.alternativeCastingCostAbility.getMor(game))) {
            return false;
        }
        controller.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
        return true;
    }
}

