/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DemonicConsultationEffect
extends OneShotEffect {
    DemonicConsultationEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a card name. Exile the top six cards of your library, then reveal cards from the top of your library until you reveal a card with the chosen name. Put that card into your hand and exile all other cards revealed this way";
    }

    private DemonicConsultationEffect(DemonicConsultationEffect effect) {
        super((OneShotEffect)effect);
    }

    public DemonicConsultationEffect copy() {
        return new DemonicConsultationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.ALL.getChoice(controller, game, source, false);
        controller.moveCards(controller.getLibrary().getTopCards(game, 6), Zone.EXILED, source, game);
        CardsImpl cardsToReveal = new CardsImpl();
        Card cardToHand = null;
        for (Card card : controller.getLibrary().getCards(game)) {
            cardsToReveal.add(card);
            if (!CardUtil.haveSameNames((String)card.getName(), (String)cardName)) continue;
            cardToHand = card;
            break;
        }
        controller.moveCards(cardToHand, Zone.HAND, source, game);
        controller.revealCards(sourceObject.getIdName(), (Cards)cardsToReveal, game);
        cardsToReveal.remove(cardToHand);
        controller.moveCards((Cards)cardsToReveal, Zone.EXILED, source, game);
        return true;
    }
}

