/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DenseCanopyCantBlockEffect
extends RestrictionEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Creatures with flying");

    public DenseCanopyCantBlockEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "creatures with flying can block only creatures with flying";
    }

    private DenseCanopyCantBlockEffect(DenseCanopyCantBlockEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return filter.match(permanent, source.getControllerId(), source, game);
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        return attacker.hasAbility((Ability)FlyingAbility.getInstance(), game);
    }

    public DenseCanopyCantBlockEffect copy() {
        return new DenseCanopyCantBlockEffect(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlyingAbility.class));
    }
}

