/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RevealLibraryPutIntoHandEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class DepalaPilotExemplarEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Dwarf and Vehicle cards");

    DepalaPilotExemplarEffect() {
        super(Outcome.DrawCard);
        this.staticText = "pay {X}. If you do, reveal the top X cards of your library, put all Dwarf and Vehicle cards from among them into your hand, then put the rest on the bottom of your library in a random order";
    }

    private DepalaPilotExemplarEffect(DepalaPilotExemplarEffect effect) {
        super((OneShotEffect)effect);
    }

    public DepalaPilotExemplarEffect copy() {
        return new DepalaPilotExemplarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ManaCostsImpl cost = new ManaCostsImpl("{X}");
            int xValue = controller.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to reveal)", game, source, true);
            cost.add((Object)new GenericManaCost(xValue));
            if (cost.pay(source, game, source, source.getControllerId(), false) && xValue > 0) {
                new RevealLibraryPutIntoHandEffect(xValue, filter, Zone.LIBRARY, false).apply(game, source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.DWARF.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
    }
}

