/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DeputyOfDetentionExileEffect
extends OneShotEffect {
    DeputyOfDetentionExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target nonland permanent an opponent controls and all other nonland permanents that player controls with the same name as that permanent until {this} leaves the battlefield";
    }

    private DeputyOfDetentionExileEffect(DeputyOfDetentionExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent targeted = game.getPermanent(source.getFirstTarget());
        if (permanent == null || controller == null || targeted == null) {
            return false;
        }
        FilterNonlandPermanent filter = new FilterNonlandPermanent();
        filter.add((Predicate)new ControllerIdPredicate(targeted.getControllerId()));
        filter.add((Predicate)new NamePredicate(targeted.getName()));
        LinkedHashSet<Permanent> toExile = new LinkedHashSet<Permanent>();
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, controller.getId(), game)) {
            toExile.add(creature);
        }
        if (!toExile.isEmpty()) {
            controller.moveCardsToExile(toExile, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), permanent.getIdName());
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        }
        return true;
    }

    public DeputyOfDetentionExileEffect copy() {
        return new DeputyOfDetentionExileEffect(this);
    }
}

