/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.keyword.MorphAbility;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DermoplasmEffect
extends OneShotEffect {
    DermoplasmEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a creature card with a morph ability from your hand onto the battlefield face up. If you do, return {this} to its owner's hand";
    }

    private DermoplasmEffect(DermoplasmEffect effect) {
        super((OneShotEffect)effect);
    }

    public DermoplasmEffect copy() {
        return new DermoplasmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent thisCreature = game.getPermanent(source.getId());
        FilterCreatureCard filter = new FilterCreatureCard("a creature card with a morph ability");
        filter.add((Predicate)new AbilityPredicate(MorphAbility.class));
        PutCardFromHandOntoBattlefieldEffect effect = new PutCardFromHandOntoBattlefieldEffect((FilterCard)filter);
        if (effect.apply(game, source) && thisCreature != null) {
            effect = new ReturnToHandTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(thisCreature.getId(), game));
            effect.apply(game, source);
            return true;
        }
        return false;
    }
}

