/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.DragonToken;
import mage.players.Player;
import mage.target.Target;

class DescentOfTheDragonsEffect
extends OneShotEffect {
    DescentOfTheDragonsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy any number of target creatures. For each creature destroyed this way, its controller creates a 4/4 red Dragon creature token with flying";
    }

    private DescentOfTheDragonsEffect(DescentOfTheDragonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DescentOfTheDragonsEffect copy() {
        return new DescentOfTheDragonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashMap<UUID, Integer> playersWithTargets = new HashMap<UUID, Integer>();
            for (Target target : source.getTargets()) {
                for (UUID permanentId : target.getTargets()) {
                    Permanent permanent = game.getPermanent(permanentId);
                    if (permanent == null) continue;
                    UUID controllerOfTargetId = permanent.getControllerId();
                    if (!permanent.destroy(source, game, false)) continue;
                    int count = playersWithTargets.getOrDefault(controllerOfTargetId, 0);
                    playersWithTargets.put(controllerOfTargetId, count + 1);
                }
            }
            game.processAction();
            DragonToken dragonToken = new DragonToken();
            for (Map.Entry amountTokensPerPlayer : playersWithTargets.entrySet()) {
                dragonToken.putOntoBattlefield(((Integer)amountTokensPerPlayer.getValue()).intValue(), game, source, (UUID)amountTokensPerPlayer.getKey());
            }
            return true;
        }
        return false;
    }
}

