/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.DroneToken2;
import mage.players.Player;

class DesculptingBlastEffect
extends OneShotEffect {
    DesculptingBlastEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target nonland permanent to its owner's hand. If it was attacking, create a 1/1 colorless Drone artifact creature token with flying and \"This token can block only creatures with flying.\"";
    }

    private DesculptingBlastEffect(DesculptingBlastEffect effect) {
        super((OneShotEffect)effect);
    }

    public DesculptingBlastEffect copy() {
        return new DesculptingBlastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        boolean flag = permanent.isAttacking();
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        if (flag) {
            new DroneToken2().putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

