/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EscapeAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;

class DesdemonaFreedomsEdgeEffect
extends ContinuousEffectImpl {
    DesdemonaFreedomsEdgeEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "target creature card in your graveyard that's an artifact or that has mana value 3 or less gains escape until end of turn. The escape cost is equal to its mana cost plus exile two other cards from your graveyard. <i>(You may cast it from your graveyard for its escape cost this turn.)</i>";
    }

    private DesdemonaFreedomsEdgeEffect(DesdemonaFreedomsEdgeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null || card.getManaCost().getText().isEmpty()) {
            return false;
        }
        EscapeAbility ability = new EscapeAbility(card, card.getManaCost().getText(), 2);
        ability.setSourceId(card.getId());
        ability.setControllerId(card.getOwnerId());
        game.getState().addOtherAbility(card, (Ability)ability);
        return true;
    }

    public DesdemonaFreedomsEdgeEffect copy() {
        return new DesdemonaFreedomsEdgeEffect(this);
    }
}

