/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.game.stack.StackObject;

class DesertionEffect
extends OneShotEffect {
    DesertionEffect() {
        super(Outcome.Detriment);
        this.staticText = "counter target spell. If an artifact or creature spell is countered this way, put that card onto the battlefield under your control instead of into its owner's graveyard";
    }

    private DesertionEffect(DesertionEffect effect) {
        super((OneShotEffect)effect);
    }

    public DesertionEffect copy() {
        return new DesertionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject spell = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        return game.getStack().counter(spell.getId(), source, game, spell.isArtifact(game) || spell.isCreature(game) ? PutCards.BATTLEFIELD : PutCards.GRAVEYARD);
    }
}

