/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DesmondMilesEffect
extends OneShotEffect {
    protected final DynamicValue amount;

    public DesmondMilesEffect(DynamicValue amount, String message) {
        super(Outcome.Benefit);
        this.amount = amount;
        this.staticText = "surveil X" + (message.isEmpty() ? "" : ", ") + message;
    }

    private DesmondMilesEffect(DesmondMilesEffect effect) {
        super((OneShotEffect)effect);
        this.amount = effect.amount;
    }

    public DesmondMilesEffect copy() {
        return new DesmondMilesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = this.amount.calculate(game, source, (Effect)this);
        return player.surveil(xValue, source, game);
    }
}

