/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.cards.d.TargetControlledSource;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.TargetSource;
import mage.util.CardUtil;

class DesperateGambitEffect
extends PreventionEffectImpl {
    private final TargetSource target;
    private boolean wonFlip;

    public DesperateGambitEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "Choose a source you control and flip a coin. If you win the flip, the next time that source would deal damage this turn, it deals double that damage instead. If you lose the flip, the next time it would deal damage this turn, prevent that damage";
        this.target = new TargetControlledSource();
    }

    private DesperateGambitEffect(DesperateGambitEffect effect) {
        super((PreventionEffectImpl)effect);
        this.target = effect.target.copy();
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player you = game.getPlayer(source.getControllerId());
        if (you == null) {
            this.discard();
            return;
        }
        this.target.choose(Outcome.Benefit, source.getControllerId(), source.getSourceId(), source, game);
        this.wonFlip = you.flipCoin(source, game, true);
    }

    public DesperateGambitEffect copy() {
        return new DesperateGambitEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getSourceId().equals(this.target.getFirstTarget())) {
            MageObject object = game.getObject(event.getSourceId());
            if (object == null) {
                game.informPlayers("Couldn't find source of damage");
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && object != null && super.applies(event, source, game) && event instanceof DamageEvent && event.getAmount() > 0) {
            if (this.wonFlip) {
                event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
                this.discard();
            } else {
                this.preventDamageAction(event, source, game);
                this.discard();
                return true;
            }
        }
        return false;
    }
}

