/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DesperateRavingsEffect
extends OneShotEffect {
    DesperateRavingsEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw two cards, then discard a card at random";
    }

    private DesperateRavingsEffect(DesperateRavingsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DesperateRavingsEffect copy() {
        return new DesperateRavingsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.drawCards(2, source, game);
            Cards hand = player.getHand();
            Card card = hand.getRandom(game);
            player.discard(card, false, source, game);
            return true;
        }
        return false;
    }
}

