/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;

class DesperateResearchEffect
extends OneShotEffect {
    DesperateResearchEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top seven cards of your library and put all of them with that name into your hand. Exile the rest";
    }

    private DesperateResearchEffect(DesperateResearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public DesperateResearchEffect copy() {
        return new DesperateResearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || cardName == null) {
            return false;
        }
        CardsImpl cardsToExile = new CardsImpl(player.getLibrary().getTopCards(game, 7));
        player.revealCards(source, (Cards)cardsToExile, game);
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new NamePredicate(cardName));
        CardsImpl cardsToKeep = new CardsImpl(cardsToExile.getCards(filter, game));
        cardsToExile.removeAll((Collection)cardsToKeep);
        player.moveCards((Cards)cardsToKeep, Zone.HAND, source, game);
        player.moveCards((Cards)cardsToExile, Zone.EXILED, source, game);
        return true;
    }
}

