/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DestructiveRevelryEffect
extends OneShotEffect {
    DestructiveRevelryEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact or enchantment. {this} deals 2 damage to that permanent's controller";
    }

    private DestructiveRevelryEffect(DestructiveRevelryEffect effect) {
        super((OneShotEffect)effect);
    }

    public DestructiveRevelryEffect copy() {
        return new DestructiveRevelryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            permanent.destroy(source, game, false);
            Player permController = game.getPlayer(permanent.getControllerId());
            if (permController != null) {
                permController.damage(2, source.getSourceId(), source, game);
                return true;
            }
        }
        return false;
    }
}

