/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DetectionTowerEffect
extends AsThoughEffectImpl {
    DetectionTowerEffect() {
        super(AsThoughEffectType.HEXPROOF, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, your opponents and creatures with hexproof they control can be the targets of spells and abilities you control as though they didn't have hexproof";
    }

    private DetectionTowerEffect(DetectionTowerEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public DetectionTowerEffect copy() {
        return new DetectionTowerEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (affectedControllerId.equals(source.getControllerId())) {
            if (game.getOpponents(source.getControllerId()).contains(objectId)) {
                return true;
            }
            Permanent creature = game.getPermanent(objectId);
            if (creature != null && game.getOpponents(source.getControllerId()).contains(creature.getControllerId())) {
                return true;
            }
        }
        return false;
    }
}

