/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetLandPermanent;
import mage.target.targetadjustment.TargetAdjuster;
import mage.target.targetadjustment.ThatPlayerControlsTargetAdjuster;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DeusOfCalamityTriggeredAbility
extends TriggeredAbilityImpl {
    public DeusOfCalamityTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DestroyTargetEffect(), false);
        this.addTarget((Target)new TargetLandPermanent());
        this.setTargetAdjuster((TargetAdjuster)new ThatPlayerControlsTargetAdjuster());
    }

    private DeusOfCalamityTriggeredAbility(DeusOfCalamityTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DeusOfCalamityTriggeredAbility copy() {
        return new DeusOfCalamityTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getSourceId().equals(this.getSourceId()) && event.getAmount() > 5 && game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} deals 6 or more damage to an opponent, destroy target land that player controls.";
    }
}

