/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class DevastatingDreamsAdditionalCost
extends VariableCostImpl {
    DevastatingDreamsAdditionalCost() {
        super(VariableCostType.ADDITIONAL, "cards to discard randomly");
        this.text = "as an additional cost to cast this spell, discard X cards at random";
    }

    private DevastatingDreamsAdditionalCost(DevastatingDreamsAdditionalCost cost) {
        super((VariableCostImpl)cost);
    }

    public DevastatingDreamsAdditionalCost copy() {
        return new DevastatingDreamsAdditionalCost(this);
    }

    public int getMaxValue(Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            return controller.getHand().size();
        }
        return 0;
    }

    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        TargetCardInHand target = new TargetCardInHand(xValue, new FilterCard());
        return new DiscardTargetCost(target, true);
    }
}

