/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetOpponent;

class DevastatingMasteryAlternativeCostEffect
extends OneShotEffect {
    private final UUID alternativeCostOriginalID;

    DevastatingMasteryAlternativeCostEffect(UUID alternativeCostOriginalID) {
        super(Outcome.Detriment);
        this.staticText = "if the {2}{W}{W} cost was paid, an opponent chooses up to two nonland permanents they control and returns them to their owner's hand.<br>";
        this.alternativeCostOriginalID = alternativeCostOriginalID;
    }

    private DevastatingMasteryAlternativeCostEffect(DevastatingMasteryAlternativeCostEffect effect) {
        super((OneShotEffect)effect);
        this.alternativeCostOriginalID = effect.alternativeCostOriginalID;
    }

    public DevastatingMasteryAlternativeCostEffect copy() {
        return new DevastatingMasteryAlternativeCostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetOpponent targetOpponent;
        if (!AlternativeCostSourceAbility.getActivatedStatus((Game)game, (Ability)source, (UUID)this.alternativeCostOriginalID, (boolean)false)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (!player.chooseTarget(Outcome.DrawCard, (Target)(targetOpponent = new TargetOpponent(true)), source, game)) {
            return false;
        }
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 2, (FilterPermanent)StaticFilters.FILTER_PERMANENTS_NON_LAND, true);
        opponent.choose(Outcome.ReturnToHand, (Target)target, source, game);
        return opponent.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
    }
}

