/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DevilishValetEffect
extends OneShotEffect {
    DevilishValetEffect() {
        super(Outcome.Benefit);
        this.staticText = "double {this}'s power until end of turn";
    }

    private DevilishValetEffect(DevilishValetEffect effect) {
        super((OneShotEffect)effect);
    }

    public DevilishValetEffect copy() {
        return new DevilishValetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BoostSourceEffect(permanent.getPower().getValue(), 0, Duration.EndOfTurn), source);
        return true;
    }
}

