/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class DiabolicRevelationEffect
extends OneShotEffect {
    DiabolicRevelationEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for up to X cards, put those cards into your hand, then shuffle";
    }

    private DiabolicRevelationEffect(DiabolicRevelationEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiabolicRevelationEffect copy() {
        return new DiabolicRevelationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue < 1) {
            player.shuffleLibrary(source, game);
            return true;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, xValue, StaticFilters.FILTER_CARD);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl();
        for (UUID targetId : target.getTargets()) {
            Card card = player.getLibrary().getCard(targetId, game);
            if (card == null) continue;
            cards.add(card);
        }
        if (!cards.isEmpty()) {
            player.moveCards((Cards)cards, Zone.HAND, source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

