/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DieYoungEffect
extends OneShotEffect {
    DieYoungEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Choose target creature. You get {E}{E}, then you may pay any amount of {E}. The creature gets -1/-1 until end of turn for each {E} paid this way";
    }

    private DieYoungEffect(DieYoungEffect effect) {
        super((OneShotEffect)effect);
    }

    public DieYoungEffect copy() {
        return new DieYoungEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent targetCreature;
            PayEnergyCost cost;
            new GetEnergyCountersControllerEffect(2).apply(game, source);
            int max = controller.getCountersCount(CounterType.ENERGY);
            int numberToPayed = controller.getAmount(0, max, "How many energy counters do you like to pay? (maximum = " + max + ')', source, game);
            if (numberToPayed > 0 && (cost = new PayEnergyCost(numberToPayed)).pay(source, game, source, source.getControllerId(), true) && (targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
                BoostTargetEffect effect = new BoostTargetEffect(numberToPayed *= -1, numberToPayed, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

