/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class DigUpTheBodyEffect
extends OneShotEffect {
    DigUpTheBodyEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill two cards, then you may return a creature card from your graveyard to your hand";
    }

    private DigUpTheBodyEffect(DigUpTheBodyEffect effect) {
        super((OneShotEffect)effect);
    }

    public DigUpTheBodyEffect copy() {
        return new DigUpTheBodyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(2, source, game);
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return true;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }
}

