/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class DimirMachinationsEffect
extends OneShotEffect {
    DimirMachinationsEffect() {
        super(Outcome.Neutral);
        this.staticText = "Look at the top three cards of target player's library. Exile any number of those cards, then put the rest back in any order";
    }

    private DimirMachinationsEffect(DimirMachinationsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DimirMachinationsEffect copy() {
        return new DimirMachinationsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetPlayer != null) {
            CardsImpl cards = new CardsImpl(targetPlayer.getLibrary().getTopCards(game, 3));
            if (!cards.isEmpty()) {
                controller.lookAtCards(source, null, (Cards)cards, game);
                TargetCard targetExile = new TargetCard(0, Integer.MAX_VALUE, Zone.LIBRARY, new FilterCard("cards to exile"));
                if (controller.choose(Outcome.Exile, (Cards)cards, targetExile, source, game)) {
                    CardsImpl toExile = new CardsImpl((Collection)targetExile.getTargets());
                    controller.moveCards((Cards)toExile, Zone.EXILED, source, game);
                    cards.removeAll((Collection)toExile);
                }
                controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
            }
            return true;
        }
        return false;
    }
}

