/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DingusStaffEffect
extends OneShotEffect {
    DingusStaffEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to that creature's controller";
    }

    private DingusStaffEffect(DingusStaffEffect effect) {
        super((OneShotEffect)effect);
    }

    public DingusStaffEffect copy() {
        return new DingusStaffEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent permanent = (Permanent)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.BATTLEFIELD);
        if (permanent != null && (controller = game.getPlayer(permanent.getControllerId())) != null) {
            controller.damage(2, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

