/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DireTacticsEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.HUMAN, "");

    DireTacticsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target creature. If you don't control a Human, you lose life equal to that creature's toughness.";
    }

    private DireTacticsEffect(DireTacticsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DireTacticsEffect copy() {
        return new DireTacticsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        int toughness = permanent.getToughness().getValue();
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        if (game.getBattlefield().countAll(filter, player.getId(), game) < 1) {
            player.loseLife(toughness, game, source, false);
        }
        return true;
    }
}

