/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DisappearEffect
extends OneShotEffect {
    DisappearEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return enchanted creature and {this} to their owners' hands";
    }

    private DisappearEffect(DisappearEffect effect) {
        super((OneShotEffect)effect);
    }

    public DisappearEffect copy() {
        return new DisappearEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent aura = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && aura != null && aura.getAttachedTo() != null) {
            Permanent enchantedCreature = game.getPermanent(aura.getAttachedTo());
            controller.moveCards((Card)aura, Zone.HAND, source, game);
            if (enchantedCreature != null) {
                controller.moveCards((Card)enchantedCreature, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }
}

