/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.AttachedToPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DisarmEffect
extends OneShotEffect {
    DisarmEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Unattach all Equipment from target creature";
    }

    private DisarmEffect(DisarmEffect effect) {
        super((OneShotEffect)effect);
    }

    public DisarmEffect copy() {
        return new DisarmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature != null) {
            FilterPermanent creatureFilter = new FilterPermanent();
            creatureFilter.add((Predicate)new PermanentIdPredicate(creature.getId()));
            FilterPermanent equipmentFilter = new FilterPermanent();
            equipmentFilter.add((ObjectSourcePlayerPredicate)new AttachedToPredicate(creatureFilter));
            equipmentFilter.add((Predicate)SubType.EQUIPMENT.getPredicate());
            for (Permanent equipment : game.getBattlefield().getActivePermanents(equipmentFilter, source.getControllerId(), source, game)) {
                creature.removeAttachment(equipment.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

